#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/io.h>
  //PORTD
#define A_High PORTD |= 0x04  // A
#define A_Low PORTD &= ~0x04  // Arduino Uno 2번핀
#define B_High PORTD |= 0x08  // B
#define B_Low PORTD &= ~0x08  // Arduino Uno 3번핀
#define C_High PORTD |= 0x10  // C
#define C_Low PORTD &= ~0x10  // Arduino Uno 4번핀
#define D_High PORTD |= 0x20  // D
#define D_Low PORTD &= ~0x20  // Arduino Uno 5번핀
#define R1_ON PORTD |= 0x40 // Red1
#define R1_OFF PORTD &= ~0x40 // Arduino Uno 6번핀
#define G1_ON PORTD |= 0x80 // Green1
#define G1_OFF PORTD &= ~0x80 // Arduino Uno 7번핀
#define B1_ON PORTB |= 0x01 // Blue1
#define B1_OFF PORTB &= ~0x01 // Arduino Uno 8번핀
// PORTB
#define R2_ON PORTB |= 0x02 // Red2
#define R2_OFF PORTB &= ~0x02 // Arduino Uno 9번핀
#define G2_ON PORTB |= 0x04 // Green2
#define G2_OFF PORTB &= ~0x04 // Arduino Uno 10번핀
#define B2_ON PORTB |= 0x08 // Blue2
#define B2_OFF PORTB &= ~0x08 // Arduino Uno 11번핀
#define Clk_enable PORTB |= 0x10  // Clk
#define Clk_disable PORTB &= ~0x10  // Arduino Uno 12번핀
#define OE_enable PORTB &= ~0x20  // Output_Enable(OE)
#define OE_disable PORTB |= 0x20  // Arduino Uno 13번핀
// PORTC
#define LE_enable PORTC |= 0x08 // Latch_Enable(LE)
#define LE_disable PORTC &= ~0x08 // Arduino Uno A3번핀 
const int __attribute__((progmem)) string[][64] = { 
0x00,0x00,0x00,0xfffc,0xfffc,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xe000,0xe000,0xe000,0xf000,0xf000,0x7800,0x7c00,0x3e00,0x1f80,0x7e0,0x3fe,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x780,0x781,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x7f81,0x7f81,0x781,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x00, //가
0x00,0x00,0x00,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xf03c,0xfff8,0x7ff0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x7f80,0x7f80,0x780,0x780,0x780,0x780,0x780,0x7bc,0x7bf,0x78f,0x780,0x780,0x780,0x780,0x780,0x00, //나
0x00,0x00,0x00,0xfff8,0xfffc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xf03c,0xfff8,0x3ff0,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x787,0x787,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x7f80,0x7f80,0x780,0x780,0x780,0x780,0x780,0x7f8,0x7ff,0x79f,0x787,0x780,0x780,0x780,0x780,0x00, //다
0x00,0x00,0x00,0xfffc,0xfffc,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfff8,0xfffc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xf03c,0xfffc,0x3ff8,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x781,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x781,0x780,0x7f80,0x7f80,0x780,0x780,0x780,0x780,0x780,0x7f8,0x7ff,0x79f,0x783,0x780,0x780,0x780,0x780,0x00, //라
0x00,0x00,0x00,0xfff8,0xfffc,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xc03c,0xfffc,0xfff8,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x781,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x7f83,0x7f83,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x781,0x780,0x780,0x780,0x00, //마
0x00,0x00,0x00,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0xfffc,0xfffc,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0x803c,0xc03c,0xfffc,0xfff8,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x7f83,0x7f83,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x781,0x780,0x780,0x780,0x00, //바
0x00,0x00,0x00,0x1e00,0x1e00,0x1e00,0x1e00,0x1e00,0xe00,0xe00,0xf00,0xf00,0x1f00,0x3f00,0x3f80,0x7f80,0xff80,0xf3c0,0xe3c0,0xe1e0,0xc1e0,0xc0f0,0x80f0,0x8078,0x7c,0x3c,0x1e,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x7f80,0x7f80,0x781,0x781,0x783,0x783,0x787,0x787,0x78f,0x78f,0x78f,0x78e,0x780,0x780,0x780,0x00, //사
0x00,0x00,0x00,0x3f80,0x7fe0,0xf9f0,0xe0f0,0xe078,0xc078,0xc03c,0x803c,0x803c,0x803c,0x803c,0x801c,0x801c,0x801c,0x803c,0x803c,0x803c,0x803c,0xc03c,0xc078,0xe078,0xe0f0,0xf9f0,0x7fe0,0x3f80,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x780,0x780,0x780,0x781,0x781,0x783,0x783,0x787,0x787,0x787,0x787,0x787,0x787,0x7f87,0x7f87,0x787,0x787,0x787,0x783,0x783,0x781,0x781,0x780,0x780,0x780,0x780,0x780,0x780,0x00, //아
0x00,0x00,0x00,0xfffc,0xfffc,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3e00,0x3e00,0x3e00,0x7e00,0x7f00,0x7f00,0xf780,0xf780,0xe3c0,0xc3e0,0xc1f0,0x80f8,0x7c,0x3e,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x79f,0x79f,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x7f80,0x7f80,0x780,0x780,0x780,0x780,0x781,0x783,0x787,0x78f,0x7bf,0x7bc,0x780,0x780,0x780,0x00, //자
0x00,0x00,0x00,0xffe0,0xffe0,0x00,0x00,0x00,0xfffc,0xfffc,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3e00,0x3e00,0x3e00,0x7e00,0x7f00,0xff00,0xf780,0xe3c0,0xe3e0,0xc1f0,0x80fc,0x3e,0x1c,0x00,0x00,0x00,0x00,0x00,0x380,0x783,0x783,0x780,0x780,0x780,0x79f,0x79f,0x780,0x780,0x780,0x780,0x780,0x780,0x7f80,0x7f80,0x780,0x780,0x780,0x780,0x780,0x781,0x783,0x787,0x79f,0x7be,0x7b8,0x780,0x780,0x00, //차
0x00,0x00,0x00,0xfffc,0xfffc,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0xfffe,0xc7fe,0xc000,0xc000,0xe000,0xe000,0xf000,0xf000,0x7800,0x7c00,0x3e00,0x1f80,0x7f0,0x3fe,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x780,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x7f81,0x7f81,0x781,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x00, //카
0x00,0x00,0x00,0xfff8,0xfffc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xfffc,0xfffc,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0xe03c,0xfff8,0x7ff8,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x787,0x787,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x780,0x787,0x787,0x7f80,0x7f80,0x780,0x780,0x780,0x780,0x780,0x780,0x7fc,0x7ff,0x79f,0x780,0x780,0x780,0x780,0x00, //타
0x00,0x00,0x00,0xfffe,0xfffe,0x00,0x00,0xc0e0,0xc0e0,0xc0e0,0xc0e0,0xc0e0,0xc0e0,0xc0e0,0xc0e0,0xc1e0,0xc1e0,0xc1e0,0xc1e0,0xc1e0,0xe1e0,0xe1e0,0xe1e0,0xe1e0,0xe1e0,0xe1e0,0xfffe,0x7fe,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x79f,0x79f,0x780,0x780,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x783,0x7f83,0x7f81,0x781,0x781,0x781,0x781,0x781,0x781,0x7bf,0x7bf,0x787,0x780,0x780,0x780,0x780,0x00, //파
0x00,0x00,0x00,0xffe0,0xffe0,0x00,0x00,0xfffe,0xfffe,0x00,0x00,0x00,0x7f80,0xffe0,0xe1f0,0xc0f8,0x8078,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x8078,0xc0f8,0xe1f0,0xffe0,0x7f80,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x781,0x781,0x780,0x780,0x79f,0x79f,0x780,0x780,0x780,0x780,0x781,0x783,0x787,0x7f87,0x7f8f,0x78f,0x78f,0x78f,0x78f,0x78f,0x787,0x787,0x783,0x781,0x780,0x780,0x780,0x780,0x00, //하

0x00,0x00,0x00,0x00,0x00,0xc000,0xe000,0xe000,0xe000,0xf000,0xf000,0xf000,0xf800,0x7800,0x7c00,0x7c00,0x3c00,0x3e00,0x3e00,0xfe00,0xff00,0x1f00,0xf80,0xf80,0xf80,0x7c0,0x7c0,0x3e0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0f,0x0f,0x1f,0x1f,0x1f,0x3e,0x3e,0x7c,0x7c,0x78,0xf8,0xf8,0x1f0,0x1ff,0x1ff,0x3e0,0x3e0,0x7c0,0x7c0,0x7c0,0xf80,0xf80,0x00,0x00,0x00,0x00, //A
0x00,0x00,0x00,0x00,0x00,0xff00,0xff00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0xff00,0xff00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0xff00,0xff00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0x1f8,0x1f0,0x3e0,0x3e0,0x3e0,0x1e0,0x1f0,0xf8,0x7f,0xff,0x1f0,0x3e0,0x7c0,0x7c0,0x7c0,0x7c0,0x7e0,0x3e0,0x1f8,0xff,0x3f,0x00,0x00,0x00,0x00, //B
0x00,0x00,0x00,0x00,0x00,0xf000,0xfc00,0x3f00,0x1f80,0xf80,0x7c0,0x7c0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x7c0,0x7c0,0xf80,0x1f80,0x3f00,0xfc00,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0x1f0,0x3e0,0x3e0,0x7c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c0,0x3e0,0x3e0,0x3e0,0x1f0,0xfc,0x7f,0x1f,0x00,0x00,0x00,0x00, //C
0x00,0x00,0x00,0x00,0x00,0xffc0,0xffc0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0xffc0,0xffc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x3f,0x7e,0xf8,0x1f0,0x3f0,0x3e0,0x3e0,0x3e0,0x7c0,0x7c0,0x7c0,0x7c0,0x3c0,0x3e0,0x3e0,0x3e0,0x1f0,0x1f0,0xf8,0x7e,0x3f,0x07,0x00,0x00,0x00,0x00, //D
0x00,0x00,0x00,0x00,0x00,0xff80,0xff80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xff80,0xff80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xff80,0xff80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3ff,0x3ff,0x00,0x00,0x00,0x00, //E
0x00,0x00,0x00,0x00,0x00,0xff00,0xff00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0xff00,0xff00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //F
0x00,0x00,0x00,0x00,0x00,0xf000,0xfc00,0x7f00,0x1f80,0xf80,0x7c0,0x7c0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x7c0,0x7c0,0xf80,0x1f80,0x7e00,0xfc00,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0x1f8,0x3e0,0x7c0,0x7c0,0xf80,0x00,0x00,0x00,0x00,0xffe,0xffe,0xf80,0xf80,0xf80,0xf80,0xf80,0xfc0,0xfe0,0xff8,0xfff,0xf3f,0x00,0x00,0x00,0x00, //G
0x00,0x00,0x00,0x00,0x00,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0xffc0,0xffc0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3ff,0x3ff,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x00,0x00,0x00,0x00, //H
0x00,0x00,0x00,0x00,0x00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00, //I
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f00,0x1f00,0x1f00,0x3e00,0x3e00,0xfc00,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x3c,0x3c,0x3c,0x3e,0x1f,0x1f,0x07,0x00,0x00,0x00,0x00, //J
0x00,0x00,0x00,0x00,0x00,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x87c0,0xc7c0,0xe7c0,0xf7c0,0xffc0,0xffc0,0xffc0,0xffc0,0xcfc0,0x87c0,0x87c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f0,0xf8,0x7c,0x3e,0x1f,0x0f,0x07,0x03,0x01,0x00,0x01,0x03,0x07,0x07,0x0f,0x1f,0x3f,0x3e,0x7e,0xfc,0x1f8,0x1f8,0x3f0,0x00,0x00,0x00,0x00, //K
0x00,0x00,0x00,0x00,0x00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0xfe00,0xfe00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x00,0x00,0x00,0x00, //L
0x00,0x00,0x00,0x00,0x00,0x7e0,0xfe0,0xfe0,0xfe0,0x1fe0,0x1fe0,0x1fe0,0x3fe0,0x3fe0,0x3fe0,0x7fe0,0x7fe0,0x7be0,0xfbe0,0xfbe0,0xf3e0,0xf3e0,0xf3e0,0xe3e0,0xe3e0,0xe3e0,0xc3e0,0xc3e0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc0,0xfe0,0xfe0,0xfe0,0xff0,0xff0,0xff0,0xff8,0xff8,0xff8,0xffc,0xffc,0xfbc,0xfbe,0xfbe,0xf9e,0xf9f,0xf9f,0xf8f,0xf8f,0xf8f,0xf87,0xf87,0x00,0x00,0x00,0x00, //M
0x00,0x00,0x00,0x00,0x00,0x7c0,0xfc0,0xfc0,0x1fc0,0x3fc0,0x3fc0,0x7fc0,0xffc0,0xffc0,0xf7c0,0xf7c0,0xe7c0,0xc7c0,0xc7c0,0x87c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e1,0x3e3,0x3e3,0x3e7,0x3ef,0x3ef,0x3ff,0x3ff,0x3fe,0x3fc,0x3fc,0x3f8,0x3f0,0x3f0,0x00,0x00,0x00,0x00, //N
0x00,0x00,0x00,0x00,0x00,0xf000,0xfc00,0x7e00,0x1f00,0xf80,0x7c0,0x7c0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x7c0,0x7c0,0xf80,0x1f00,0x7e00,0xfc00,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0x1f8,0x3f0,0x7e0,0x7c0,0xf80,0xf80,0xf80,0xf80,0xf00,0xf00,0xf00,0xf80,0xf80,0xf80,0xf80,0x7c0,0x7e0,0x3f0,0x1f8,0x7f,0x1f,0x00,0x00,0x00,0x00, //O
0x00,0x00,0x00,0x00,0x00,0xff80,0xff80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xff80,0xff80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0xf80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xff,0x1f8,0x1f0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x1f0,0x1f8,0x7f,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //P
0x00,0x00,0x00,0x00,0x00,0xf800,0xfe00,0x3f00,0xf80,0x7c0,0x3e0,0x3e0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x3e0,0x3e0,0x7c0,0xf80,0x3f00,0xfe00,0xf800,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3f,0xfc,0x1f8,0x3f0,0x3e0,0x7c0,0x7c0,0x7c0,0x7c0,0x780,0x780,0x7c0,0x7c0,0x7c0,0x7c0,0x7ce,0x3ff,0x3fe,0x1fc,0x3fe,0x7ff,0xfcf,0x780,0x00,0x00,0x00, //Q
0x00,0x00,0x00,0x00,0x00,0xffc0,0xffc0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0xffc0,0xffc0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xff,0x1f8,0x1f0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x1f0,0xf8,0x7f,0x1f,0x7e,0x7c,0xf8,0xf8,0x1f0,0x1f0,0x1f0,0x3e0,0x3e0,0x7e0,0x00,0x00,0x00,0x00, //R
0x00,0x00,0x00,0x00,0x00,0xf000,0xfc00,0x7e00,0x1f00,0x1f00,0xf00,0xf80,0x1f00,0x3f00,0xfe00,0xfc00,0xf000,0x00,0x00,0x00,0xf80,0xf80,0xf80,0x1f00,0x3f00,0x7e00,0xfc00,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xf8,0x1f0,0x3e0,0x3e0,0x3e0,0x00,0x00,0x03,0x3f,0xff,0x1ff,0x3f0,0x7e0,0x7c0,0x7c0,0x7c0,0x3c0,0x3e0,0x1f8,0xff,0x3f,0x00,0x00,0x00,0x00, //S
0x00,0x00,0x00,0x00,0x00,0xff80,0xff80,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7ff,0x7ff,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00, //T
0x00,0x00,0x00,0x00,0x00,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x7c0,0x780,0xf80,0x3f00,0xfe00,0xf800,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x1e0,0x1f0,0x1f0,0xf8,0xfc,0x7f,0x0f,0x00,0x00,0x00,0x00, //U
0x00,0x00,0x00,0x00,0x00,0x7e0,0x7c0,0x7c0,0xf80,0xf80,0x1f00,0x1f00,0x1f00,0x3e00,0x3e00,0x3c00,0x7c00,0x7c00,0x7800,0xf800,0xf800,0xf000,0xf000,0xe000,0xe000,0xe000,0xc000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf80,0xf80,0x7c0,0x7c0,0x3c0,0x3e0,0x3e0,0x1f0,0x1f0,0x1f0,0xf8,0xf8,0x78,0x7c,0x7c,0x3e,0x3f,0x1f,0x1f,0x1f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00, //V
0x00,0x00,0x00,0x00,0x00,0xe03e,0xe03e,0xe03e,0xe07c,0xf07c,0xf07c,0xf07c,0xf878,0xf8f8,0x78f8,0x78f0,0x7cf0,0x7df0,0x3df0,0x3de0,0x3fe0,0x3fe0,0x1fe0,0x1fc0,0x1fc0,0xfc0,0xf80,0xf80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf807,0xf807,0x7c0f,0x7c0f,0x7c0f,0x3c1f,0x3e1f,0x3e1e,0x3e1e,0x1e3e,0x1f3e,0x1f3c,0x1f3c,0xf7c,0xff8,0xff8,0x7f8,0x7f8,0x7f0,0x7f0,0x3f0,0x3f0,0x3e0,0x00,0x00,0x00,0x00, //W
0x00,0x00,0x00,0x00,0x00,0xfc0,0x1f80,0x3f00,0x3e00,0x7c00,0xfc00,0xf800,0xf000,0xf000,0xe000,0xc000,0xc000,0xe000,0xf000,0xf000,0xf800,0xfc00,0x7e00,0x3e00,0x1f00,0x1f80,0xfc0,0x7e0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c0,0x3e0,0x3f0,0x1f8,0xf8,0x7c,0x7e,0x3f,0x1f,0x0f,0x0f,0x0f,0x1f,0x1f,0x3f,0x7c,0xfc,0xf8,0x1f0,0x3f0,0x3e0,0x7c0,0xfc0,0x00,0x00,0x00,0x00, //X
0x00,0x00,0x00,0x00,0x00,0x7e0,0xfc0,0x1f80,0x1f00,0x3f00,0x7e00,0x7c00,0xf800,0xf800,0xf000,0xe000,0xe000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc0,0x7c0,0x7e0,0x3e0,0x1f0,0x1f8,0xf8,0x7c,0x3e,0x3f,0x1f,0x0f,0x0f,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00, //Y
0x00,0x00,0x00,0x00,0x00,0xff00,0xff00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0x8000,0xc000,0xe000,0xf000,0xf000,0xf800,0x7c00,0x7e00,0x3e00,0x1f00,0xf80,0xff80,0xff80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3ff,0x3ff,0x3e0,0x1f0,0x1f8,0xf8,0x7c,0x3e,0x3f,0x1f,0x0f,0x07,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x7ff,0x7ff,0x00,0x00,0x00,0x00, //Z

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf000,0xf800,0x7c00,0x3e00,0x3e00,0x00,0xe000,0xf800,0xfc00,0x3e00,0x1e00,0x1f00,0x1e00,0x3e00,0xfc00,0xf800,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xf8,0xf0,0x1f0,0x1f0,0x1ff,0x1ff,0x1f0,0x1f0,0x1f0,0x1f0,0x1f8,0x1fe,0x1ff,0x1f7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //a
0x00,0x00,0x00,0x00,0x00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0xbe00,0xfe00,0xfe00,0x7e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x7e00,0xfe00,0xfe00,0xfe00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x7f,0xf9,0x1f0,0x1e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x1e0,0x1f0,0xf8,0x7f,0x1f,0x00,0x00,0x00,0x00, //b
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x3e00,0x3e00,0x1e00,0x1f00,0x1f00,0x1f00,0x1f00,0x1e00,0x3e00,0x3e00,0xfc00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0xf8,0x1f0,0x00,0x00,0x00,0x00,0x00,0x00,0x1f0,0xf8,0xfc,0x7f,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //c
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0x7c00,0x3e00,0x3e00,0x1e00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x3e00,0x3e00,0x7c00,0xf800,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1ff,0x1ff,0x1fc,0x1f8,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f8,0x1fe,0x1ff,0x1ff,0x00,0x00,0x00,0x00, //d
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x3e00,0x3e00,0x1e00,0x1f00,0xff00,0xff00,0x1f00,0x1e00,0x3e00,0x3e00,0xfc00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0x1f0,0x1f0,0x3e0,0x3e0,0x3ff,0x3ff,0x00,0x00,0x3e0,0x1f0,0x1f8,0x7f,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //e
0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0xc000,0xc000,0xc000,0xc000,0xc000,0xf800,0xf800,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x7f,0x07,0x07,0x07,0x07,0x07,0x3f,0x3f,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00, //f
0x00,0x00,0x00,0x00,0xe000,0xf800,0x7c00,0x3e00,0x3e00,0x1e00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x3e00,0x3e00,0x7c00,0xf800,0xf000,0x00,0x00,0x00,0x3e00,0x3e00,0x7c00,0xfc00,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x1fc,0x1f8,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f8,0x1fe,0x1ff,0x1f7,0x1f0,0x1f0,0xf0,0xf8,0xf8,0x7c,0x3f,0x1f,0x00,0x00,0x00,0x00, //g
0x00,0x00,0x00,0x00,0x00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0xbe00,0xfe00,0xfe00,0x7e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xff,0xf9,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x00,0x00,0x00,0x00, //h
0x00,0x00,0x00,0x00,0x00,0xe000,0xe000,0xe000,0x00,0x00,0x00,0x00,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00, //i
0x00,0xe000,0xe000,0xe000,0x00,0x00,0x00,0x00,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xfc00,0xfc00,0x00,0x03,0x03,0x03,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x00, //j
0x00,0x00,0x00,0x00,0x00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f8,0xfc,0x7e,0x3f,0x1f,0x0f,0x07,0x0f,0x1f,0x3f,0x3e,0x7c,0xfc,0xf8,0x1f0,0x3f0,0x00,0x00,0x00,0x00, //k
0x00,0x00,0x00,0x00,0x00,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00, //l
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfdf0,0xfff0,0xe7f0,0xc3f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0xc1f0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f8,0x7ff,0xf9f,0xf0f,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x1f07,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //m
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xbe00,0xfe00,0xfe00,0x7e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xff,0xf9,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //n
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x3e00,0x3e00,0x1e00,0x1f00,0x1f00,0x1f00,0x1f00,0x1e00,0x3e00,0x3e00,0xfc00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0x1f0,0x1f0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x1f0,0x1f0,0xfc,0x7f,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //o
0x00,0x00,0x00,0x00,0xbe00,0xfe00,0xfe00,0x7e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x7e00,0xfe00,0xfe00,0xfe00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x7f,0xf9,0x1f0,0x1e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x3e0,0x1e0,0x1f0,0xf8,0x7f,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //p
0x00,0x00,0x00,0x00,0xe000,0xf800,0x7c00,0x3e00,0x3e00,0x1e00,0x1f00,0x1f00,0x1f00,0x1f00,0x1f00,0x3e00,0x3e00,0x7c00,0xf800,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x1fc,0x1f8,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f8,0x1fe,0x1ff,0x1f7,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x00,0x00,0x00,0x00, //q
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x7f,0x07,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //r
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0x7c00,0x7c00,0x3c00,0x7c00,0xfc00,0xf800,0xc000,0x00,0x00,0x3e00,0x3c00,0x7c00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0xf8,0xf8,0x00,0x07,0x3f,0xff,0x1fc,0x1f0,0x1f0,0x1f0,0xf8,0x7f,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //s
0x00,0x00,0x00,0x00,0x00,0x00,0xc000,0xc000,0xc000,0xc000,0xf000,0xf000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x8000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x1f,0x1f,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x3f,0x3f,0x00,0x00,0x00,0x00,0x00,0x00, //t
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3c00,0x7c00,0xf800,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f8,0x1fe,0x1ff,0x1f7,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //u
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f00,0x1f00,0x3e00,0x3e00,0x3e00,0x7c00,0x7c00,0x7800,0xf800,0xf800,0xf000,0xf000,0xe000,0xe000,0xe000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f8,0xf8,0xf8,0x7c,0x7c,0x7c,0x3e,0x3e,0x1e,0x1f,0x1f,0x0f,0x0f,0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //v
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc3f0,0xc3e0,0xc3e0,0xe3e0,0xe7c0,0xe7c0,0xf7c0,0xf780,0xff80,0xff80,0xff00,0x7f00,0x7f00,0x7e00,0x7e00,0x3e00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f07,0x1f07,0xf8f,0xf8f,0xf8f,0x79f,0x7df,0x7df,0x3fe,0x3fe,0x3fc,0x1fc,0x1fc,0x1f8,0x1f8,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //w
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e00,0x7c00,0xf800,0xf800,0xf000,0xe000,0xc000,0xc000,0xc000,0xe000,0xf000,0xf000,0xf800,0xfc00,0x7c00,0x3f00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f0,0xf8,0xfc,0x7d,0x3f,0x1f,0x1f,0x0f,0x0f,0x1f,0x3f,0x7f,0x7c,0xf8,0x1f8,0x3f0,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //x
0x00,0x00,0x00,0x00,0x3e00,0x3e00,0x7c00,0x7c00,0x7c00,0xf800,0xf800,0xf000,0xf000,0xf000,0xe000,0xe000,0xc000,0xc000,0xc000,0x8000,0x8000,0x8000,0xc000,0xc000,0xe000,0xe000,0xfc00,0xfc00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f0,0x1f0,0x1f0,0xf8,0xf8,0xf8,0x7c,0x7c,0x3d,0x3f,0x3f,0x1f,0x1f,0x0f,0x0f,0x0f,0x07,0x07,0x07,0x03,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00, //y
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc00,0xfc00,0x00,0x00,0x00,0x00,0x8000,0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0x7e00,0xfe00,0xfe00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0xf8,0xfc,0x7e,0x3f,0x1f,0x0f,0x07,0x03,0x03,0x01,0x00,0x00,0x1ff,0x1ff,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //z

0x00,0x00,0x00,0x00,0x00,0xe000,0xf000,0xf800,0x7c00,0x3c00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x1e00,0x1e00,0x1e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3c00,0x7c00,0xf800,0xf000,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x3f,0x7c,0xf8,0xf0,0x1f0,0x1f0,0x1f0,0x1e0,0x1e0,0x1e0,0x1e0,0x1e0,0x1e0,0x1e0,0x1f0,0x1f0,0x1f0,0xf0,0xf8,0x7c,0x3f,0x1f,0x00,0x00,0x00,0x00, //0
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc000,0xf800,0xf800,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x00,0x00,0x00,0x00, //1
0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x7c00,0x3e00,0x3e00,0x3e00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0x7e00,0x3e00,0xff00,0xff00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f0,0x1f8,0xf8,0x7c,0x7f,0x3f,0x1f,0x0f,0x03,0x01,0x00,0x00,0x00,0x1ff,0x1ff,0x00,0x00,0x00,0x00, //2
0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x7c00,0x3e00,0x3e00,0x00,0x00,0x00,0x00,0xc000,0xc000,0x00,0x00,0x00,0x00,0x00,0x1e00,0x3e00,0x3e00,0xfc00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x3f,0x7c,0xf8,0xf8,0xf0,0xf0,0xf8,0xf8,0x7c,0x3f,0x7f,0xfc,0x1f0,0x1f0,0x1e0,0x3e0,0x1e0,0x1f0,0x1f0,0xfc,0x7f,0x1f,0x00,0x00,0x00,0x00, //3
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0x8000,0xc000,0xe000,0xe000,0xf000,0xf800,0x7800,0x7c00,0x3e00,0x1e00,0x1f00,0xff00,0xff00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x3e,0x3e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3d,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x1ff,0x1ff,0x3c,0x3c,0x3c,0x3c,0x3c,0x00,0x00,0x00,0x00, //4
0x00,0x00,0x00,0x00,0x00,0xfc00,0xfc00,0x7c00,0x7c00,0x7c00,0x7c00,0x3c00,0x3c00,0xfc00,0xfc00,0x7c00,0x3e00,0x00,0x00,0x00,0x00,0x00,0x1e00,0x3e00,0x3e00,0xfc00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0x1f0,0x1f0,0x1e0,0x3e0,0x3e0,0x3e0,0x1e0,0x1f0,0xf8,0xfc,0x7f,0x1f,0x00,0x00,0x00,0x00, //5
0x00,0x00,0x00,0x00,0x00,0xc000,0xf000,0xf800,0xfc00,0x7c00,0x3c00,0x3e00,0x3e00,0xfe00,0xfe00,0xfe00,0x7e00,0x3e00,0x1e00,0x3e00,0x3e00,0x3e00,0x3e00,0x7c00,0x7c00,0xf800,0xf000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xf9,0xf0,0x1f0,0x1f0,0x00,0x00,0x1f,0x7f,0xfc,0x1f0,0x1f0,0x1e0,0x3e0,0x3e0,0x1e0,0x1e0,0x1f0,0xf0,0xfc,0x7f,0x1f,0x00,0x00,0x00,0x00, //6
0x00,0x00,0x00,0x00,0x00,0xfe00,0xfe00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0x8000,0x8000,0xc000,0xc000,0xe000,0xe000,0xe000,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1ff,0x1f0,0x1f0,0xf0,0xf8,0xf8,0x7c,0x7c,0x3c,0x3e,0x3e,0x1f,0x1f,0x0f,0x0f,0x0f,0x07,0x07,0x03,0x03,0x03,0x01,0x00,0x00,0x00,0x00, //7
0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x7c00,0x3c00,0x3e00,0x3c00,0x7c00,0xfc00,0xf800,0xe000,0xf000,0xf800,0x7c00,0x3e00,0x3e00,0x1e00,0x1e00,0x3e00,0x3e00,0xfc00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x7f,0xfc,0xf8,0x1f0,0x1f0,0x1f0,0xf8,0xfc,0x7f,0x3f,0x3f,0x7f,0xf8,0x1f0,0x1e0,0x3e0,0x3e0,0x1f0,0x1f0,0xf8,0x7f,0x1f,0x00,0x00,0x00,0x00, //8
0x00,0x00,0x00,0x00,0x00,0xe000,0xf800,0xfc00,0x7c00,0x3e00,0x3e00,0x1e00,0x1e00,0x1e00,0x3e00,0x3e00,0x7c00,0xfc00,0xf800,0xe000,0x00,0x00,0x3e00,0x3e00,0x3c00,0x7c00,0xf800,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3f,0x7c,0xf8,0xf8,0x1f0,0x1f0,0x1f0,0x1e0,0x1e0,0x1e0,0x1f0,0x1fc,0x1ff,0x1ff,0x1f0,0x1f0,0x1f0,0xf8,0xf8,0x7e,0x3f,0x0f,0x00,0x00,0x00,0x00, //9

0x00,0x00,0x00,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xf000,0xf000,0xfe00,0xfe00,0xf000,0xf000,0xf000,0x7800,0x7800,0x7800,0xff00,0xff00,0x7800,0x7800,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0xf1,0x79,0x79,0x79,0x79,0x78,0x78,0x3ff,0x3ff,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x1ff,0x1ff,0x1e,0x1e,0x1e,0x1e,0x1e,0x0f,0x0f,0x0f,0x00,0x00,0x00, //＃
0x00,0x00,0x00,0x00,0xe000,0xf800,0x7c00,0x3c00,0x1e00,0x3e00,0x3c00,0x7c00,0xfc00,0xf800,0xf000,0xf000,0xfc00,0x9e00,0xf00,0x780,0x780,0x380,0x380,0x780,0x780,0xf80,0x1f00,0xfe00,0xf800,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x1f,0x3e,0x3c,0x3c,0x3c,0x3c,0x1e,0x0f,0x07,0x03,0x03,0x07,0x3cf,0x3cf,0x3df,0x3fe,0x1fc,0x1f8,0xf8,0x1f8,0x3fe,0x7df,0x78f,0xf03,0x00,0x00,0x00, //＆
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0x8000,0x8000,0x8000,0xbe00,0xfc00,0xf000,0xc000,0xe000,0xf000,0xf000,0xf800,0x7000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0xff,0xff,0x3f,0x0f,0x0f,0x1f,0x3e,0x3c,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //＊
0x00,0xf000,0xfc00,0x7f00,0xf80,0x7c0,0x3e0,0xe1f0,0xf8f8,0x7c78,0x3e7c,0x3e3c,0x1f3c,0xf3e,0xf9e,0xf9e,0xf9e,0xf9e,0xf9e,0xf9e,0xf9e,0x9f3e,0xfe3c,0xfc3c,0x78,0xf8,0x1f0,0x3e0,0x7c0,0x3f80,0xfe00,0xf000,0x00,0x7f,0x1ff,0x7f0,0xf80,0x1f00,0x3e00,0x3dff,0x79ff,0x78fc,0x78f8,0xf8f8,0xf0f8,0xf0f8,0xf078,0xf878,0x787c,0x787c,0x7c7c,0x3c3e,0x3e3f,0x1fbf,0x7ff,0x1f9,0x00,0x00,0x00,0x00,0x00,0x3c0,0x3ff,0xff, //@
0x00,0xe000,0xf000,0xf800,0x7c00,0x7c00,0x7c00,0x7c00,0xf800,0xf000,0xf800,0xfc00,0xbe00,0x1e00,0x1e00,0x3e00,0x3e00,0x7e00,0xfc00,0xf800,0xf000,0xc000,0x00,0x00,0x00,0x00,0x3c00,0x7c00,0x7c00,0xf800,0xf000,0xe000,0x00,0x1f,0x3f,0x7c,0xf8,0xf8,0x00,0x00,0x00,0x03,0x07,0x1f,0x3f,0xfe,0x1fc,0x1f8,0x1f0,0x3e0,0x1e1,0x1f3,0xff,0x7f,0x3f,0x7e,0xfc,0xf8,0xf0,0xf0,0xf8,0xfc,0x7f,0x1f, //§
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc380,0xc700,0xce00,0x1c00,0x3800,0x7000,0xef80,0xcf80,0xcf80,0xe000,0x7000,0x3800,0x1c00,0xce00,0xc700,0xc380,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c7,0x1e7,0xf7,0x78,0x3c,0x1e,0x3ff,0x3f7,0x3f7,0x0f,0x1e,0x3c,0x78,0xf7,0x1e7,0x3c7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //※
0x00,0x00,0x00,0x8000,0xc000,0xc000,0xc000,0xe000,0xe000,0x6000,0x7000,0x7000,0x3ffe,0x38,0x70,0xe0,0x380,0x700,0xe00,0xe00,0xe00,0x600,0xc700,0x7700,0x3b00,0x1f80,0x780,0x380,0x1c0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x03,0x03,0x07,0x07,0x0e,0x0e,0x7ffe,0x1c00,0xe00,0x780,0x1c0,0xe0,0x78,0x30,0x70,0x70,0xe3,0xe7,0xfc,0x1f8,0x1f0,0x1c0,0x380,0x00,0x00,0x00, //☆
0x00,0x00,0x00,0x8000,0xc000,0xc000,0xc000,0xe000,0xe000,0xe000,0xf000,0xf000,0xfffe,0xfff8,0xfff0,0xffe0,0xff80,0xff00,0xfe00,0xfe00,0xfe00,0xfe00,0xff00,0x7f00,0x3f00,0x1f80,0x780,0x380,0x1c0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x03,0x03,0x07,0x07,0x0f,0x0f,0x7fff,0x1fff,0xfff,0x7ff,0x1ff,0xff,0x7f,0x3f,0x7f,0x7f,0xff,0xff,0xfc,0x1f8,0x1f0,0x1c0,0x380,0x00,0x00,0x00, //★
0x00,0x00,0xf800,0x1f00,0x3c0,0x1e0,0x70,0x38,0x38,0x1c,0x1c,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x1c,0x1c,0x38,0x38,0x70,0x1e0,0x3c0,0x1f00,0xf800,0x00,0x00,0x00,0x00,0x1f,0xf8,0x1e0,0x380,0x700,0xe00,0x1c00,0x1c00,0x3800,0x3800,0x3800,0x7000,0x7000,0x7000,0x7000,0x7000,0x7000,0x3800,0x3800,0x3800,0x1c00,0x1c00,0xe00,0x700,0x380,0x1e0,0xf8,0x1f,0x00,0x00, //○
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfc00,0xf800,0xf000,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3f,0x7f,0xff,0xff,0xff,0x1ff,0x1ff,0xff,0xff,0xff,0x7f,0x3f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //●
0x00,0x00,0xf800,0x1f00,0x3c0,0x1e0,0x70,0x78,0xf038,0x3c1c,0xf1c,0x70e,0x38e,0x18e,0x1ce,0x1c6,0x1c6,0x1c6,0x1ce,0x18e,0x38e,0x70e,0xf1c,0x3c1c,0xf038,0x78,0x70,0x1e0,0x3c0,0x1f00,0xf800,0x00,0x00,0x00,0x1f,0x78,0x1e0,0x380,0x700,0xe00,0x1c0f,0x1c3c,0x3870,0x38e0,0x38e0,0x71c0,0x71c0,0x71c0,0x71c0,0x71c0,0x71c0,0x71c0,0x30e0,0x38e0,0x3870,0x1c3c,0x1c0f,0xe00,0x700,0x380,0x1e0,0x78,0x1f,0x00, //◎
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xe00,0xfe00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1ff,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1ff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //□
0x00,0x00,0x00,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0xfffc,0x00,0x00,0x00,0x00,0x00,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x00,0x00, //■
0x00,0x00,0x00,0x00,0x00,0x8000,0x8000,0xc000,0xe000,0xe000,0x7000,0x3800,0x3800,0x1c00,0xe00,0xe00,0x700,0x380,0x380,0x1c0,0xe0,0xe0,0x70,0x38,0x38,0xfffc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x07,0x0f,0x0e,0x1c,0x38,0x38,0x70,0xe0,0xe0,0x1c0,0x380,0x380,0x700,0xf00,0xe00,0x1c00,0x3c00,0x3800,0x7fff,0x00,0x00,0x00,0x00,0x00,0x00, //△
0x00,0x00,0x00,0x00,0x00,0xc000,0xe000,0xe000,0xf000,0xf800,0xf800,0xfc00,0xfe00,0xfe00,0xff00,0xff80,0xff80,0xffc0,0xffe0,0xffe0,0xfff0,0xfff8,0xfff8,0xfffc,0xfffe,0xfffe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x07,0x07,0x0f,0x1f,0x1f,0x3f,0x7f,0x7f,0xff,0xff,0x1ff,0x3ff,0x3ff,0x7ff,0xfff,0xfff,0x1fff,0x3fff,0x00,0x00,0x00,0x00,0x00,0x00, //▲
0x00,0x00,0x00,0x00,0x00,0x00,0xfffc,0x78,0x70,0xe0,0x1e0,0x1c0,0x380,0x380,0x700,0xe00,0xe00,0x1c00,0x3c00,0x3800,0x7000,0xf000,0xe000,0xc000,0xc000,0x8000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7fff,0x7800,0x3800,0x1c00,0x1e00,0xe00,0x700,0x780,0x380,0x1c0,0x1c0,0xe0,0x70,0x70,0x38,0x1c,0x1c,0x0f,0x0f,0x07,0x03,0x00,0x00,0x00,0x00,0x00, //▽
0x00,0x00,0x00,0x00,0x00,0x00,0xfffe,0xfffc,0xfffc,0xfff8,0xfff0,0xfff0,0xffe0,0xffc0,0xffc0,0xff80,0xff00,0xff00,0xfe00,0xfe00,0xfc00,0xf800,0xf800,0xf000,0xe000,0xe000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3fff,0x1fff,0xfff,0xfff,0x7ff,0x3ff,0x3ff,0x1ff,0xff,0xff,0x7f,0x3f,0x3f,0x1f,0x1f,0x0f,0x07,0x07,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00, //▼
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xffff,0xffff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c0,0x780,0xf00,0x1f00,0x3e00,0xffff,0xffff,0x3e00,0x1f00,0xf00,0x780,0x3c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //→
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c0,0x1c0,0x1e0,0xf8,0x7c,0xffff,0xffff,0x7c,0xf0,0x1e0,0x1c0,0x380,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xffff,0xffff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //←
0x00,0x00,0x8000,0xc000,0xe000,0xe000,0xf000,0xf800,0xfc00,0xcc00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x00,0x00,0x00,0x00,0x03,0x03,0x07,0x07,0x0f,0x1f,0x3f,0x73,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00, //↑
0x00,0x00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xcc00,0xfc00,0xf800,0xf000,0xe000,0xc000,0xc000,0x8000,0x00,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x73,0x3f,0x1f,0x0f,0x07,0x07,0x03,0x03,0x00,0x00, //↓
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c0,0x1c0,0x1e0,0xf8,0x7c,0xffff,0xffff,0x7c,0xf8,0x1e0,0x1e0,0x3c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c0,0x780,0xf00,0x1f00,0x3e00,0xffff,0xffff,0x3e00,0x1f00,0xf00,0x780,0x3c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //↔
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xffff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xffff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xffff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xffff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //〓
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0xc000,0xf000,0x3800,0x1e00,0x780,0x3c0,0xf0,0x78,0xe0,0x3c0,0xf00,0x1c00,0x7800,0xe000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x3c0,0x3f0,0x3bc,0x39e,0x387,0x381,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x380,0x383,0x38f,0x39e,0x3f8,0x3e0,0x3c0,0x300,0x00,0x00, //◁
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8000,0xc000,0xf000,0xf800,0xfe00,0xff80,0xffc0,0xfff0,0xfff8,0xffe0,0xffc0,0xff00,0xfc00,0xf800,0xe000,0xc000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x380,0x3c0,0x3f0,0x3fc,0x3fe,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3ff,0x3fe,0x3f8,0x3e0,0x3c0,0x300,0x00,0x00, //◀
0x00,0x00,0x00,0x1c0,0x7c0,0xfc0,0x3dc0,0xf1c0,0xe1c0,0x81c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x1c0,0x81c0,0xe1c0,0x71c0,0x3dc0,0xfc0,0x7c0,0x1c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x0e,0x3c,0x70,0x1e0,0x380,0xf00,0x1c00,0xf00,0x380,0x1e0,0x78,0x3c,0x0f,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //▷
0x00,0x00,0x00,0x1c0,0x7c0,0xfc0,0x3fc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0x7fc0,0x3fc0,0xfc0,0x7c0,0x1c0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x07,0x0f,0x3f,0x7f,0x1ff,0x3ff,0xfff,0x1fff,0xfff,0x3ff,0x1ff,0x7f,0x3f,0x0f,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //▶
0x00,0x8000,0x8000,0xc000,0xe000,0xf000,0xf000,0x7800,0x3c00,0x1e00,0xe00,0xf00,0x780,0x3c0,0x3c0,0x1e0,0x1e0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0f0,0xfde0,0xffe0,0xff80,0xe000,0xe000,0xf000,0xf000,0xf000,0xf000,0x00,0x03,0x07,0x0f,0x0f,0x1e,0x3c,0x78,0x78,0xf0,0x1e0,0x1c0,0x3c0,0x780,0x700,0xf00,0xe00,0x1e00,0x1e00,0x1c00,0x1c00,0x1c00,0x1e01,0x1f3f,0xfff,0x3ff,0x0f,0x0e,0x1e,0x1c,0x3f,0x3f, //♤
0x00,0x00,0x00,0x00,0x8000,0xc000,0xe000,0xf000,0xf000,0xf800,0xfc00,0xfe00,0xfe00,0xff00,0xff80,0xff80,0xffc0,0xffc0,0xffc0,0xffe0,0xffe0,0xffc0,0xffc0,0xff80,0xbf00,0xc000,0xc000,0xe000,0xe000,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x0f,0x1f,0x3f,0x7f,0xff,0x1ff,0x1ff,0x3ff,0x7ff,0x7ff,0xfff,0xfff,0x1fff,0x1fff,0x1fff,0x1fff,0x1fff,0x1fff,0xfff,0x3ef,0x0f,0x1f,0x1f,0x3f,0x00,0x00,0x00, //♠
0x00,0x3f80,0x7fe0,0xf9f0,0xf078,0xf078,0xe03c,0xe03c,0xe03c,0xc03c,0xc038,0x78,0x78,0x78,0xf0,0xf0,0x1e0,0x1e0,0x3c0,0x3c0,0x780,0xf00,0x1f00,0x1e00,0x3c00,0x7800,0xf000,0xe000,0xe000,0xc000,0x8000,0x00,0x00,0x7f0,0x1ffc,0x3e7e,0x3c3f,0x781f,0x781f,0x700f,0x700f,0x700f,0x7007,0x7800,0x7800,0x3800,0x3c00,0x1c00,0x1e00,0xf00,0xf00,0x780,0x3c0,0x3e0,0x1e0,0xf0,0x78,0x7c,0x3e,0x1f,0x0f,0x07,0x03,0x00, //♡
0x00,0x00,0x00,0x1f00,0x7fc0,0xffe0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xfff0,0xffe0,0xffe0,0xffe0,0xffc0,0xff80,0xff80,0xff00,0xff00,0xfe00,0xfc00,0xf800,0xf800,0xf000,0xe000,0xc000,0x8000,0x00,0x00,0x00,0x00,0x00,0xf8,0x3fe,0x7ff,0xfff,0xfff,0xfff,0xfff,0x1fff,0xfff,0xfff,0xfff,0x7ff,0x7ff,0x3ff,0x3ff,0x1ff,0x1ff,0xff,0x7f,0x7f,0x3f,0x1f,0x0f,0x07,0x07,0x03,0x01,0x00,0x00, //♥
0x00,0x00,0xe000,0xf800,0xfc00,0x3c00,0x1e00,0x1e00,0x1e00,0x1e00,0x1e00,0x3c00,0x7800,0xffe0,0xfff8,0xfe7c,0xf83c,0x1c,0x1e,0x1e,0x1e,0x1e,0xe01c,0xf83c,0xfc78,0xfff0,0xefe0,0xe000,0xf000,0xf000,0xf000,0x00,0x00,0x00,0x1f,0x3f,0x7c,0xf0,0xf0,0x1e0,0xe0,0xe0,0xf0,0x78,0x3c,0x1fff,0x3fff,0x78ff,0xf000,0xf000,0xe000,0xe000,0xe000,0xf000,0xf01f,0x783f,0x7cff,0x3fff,0xfff,0x1e,0x1c,0x3f,0x3f,0x00, //♧
0x00,0x00,0x00,0xc000,0xf000,0xf800,0xf800,0xfc00,0xfc00,0xfc00,0xfc00,0xf800,0xf800,0xff00,0xffc0,0xffe0,0xfff0,0xfff0,0xfff8,0xfff8,0xfff0,0xfff0,0xfff0,0xbfe0,0x8f80,0xc000,0xc000,0xe000,0xf000,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x3f,0x3f,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x3f,0x3df,0xfff,0x1fff,0x3fff,0x3fff,0x3fff,0x3fff,0x3fff,0x3fff,0x1fff,0xff7,0x3c7,0x07,0x0f,0x1f,0x1f,0x00,0x00,0x00, //♣

};
volatile unsigned char BCD_Num = 0; // 도트매트릭스 표시할 문자 색상 결정
unsigned char Dot_char_cnt = 0; // 도트매트릭스에 표시될 문자 카운팅
unsigned char move_motion = 0;  // 도트매트릭스의 디스플레이 모션 방식 설정
unsigned int Move_cnt = 32; // 도트매트릭스 왼쪽, 오른쪽 시프트 변수
unsigned int Move_cnt2 = 0; // 도트매트릭스 왼쪽, 오른쪽 시프트 변수2 
unsigned int str_speed_cnt = 0;
static unsigned int char_cnt = 0;

bool flag_Oe = 0;
ISR(TIMER2_OVF_vect)
{
  // 0.1mS 오버플로우 인터럽트 발생
  static unsigned int string_moving_speed_value = 150;  // 도트매트릭스 시프트 속도
  static unsigned int cnt = 0;
  if (cnt == 500)
  {
    LE_enable;
  }
  else if (cnt >= 1000)
  {
    LE_disable;
    cnt = 0;
  }

  str_speed_cnt++;
  if (str_speed_cnt > string_moving_speed_value)  // 문자가 50mS 머문 후 시프트 시작
  {
    str_speed_cnt = 0;
    Move_cnt2++;
    Move_cnt--;
    if (Move_cnt == 0 || Move_cnt2 == 32)
    {
      Move_cnt2 = 0;
      Move_cnt = 32; // 총 문자의 크기수를 정의하여 최종 64행의 가로를 연상 하게 함.
      BCD_Num++;
      if (BCD_Num > 7)
      {
        BCD_Num = 1;  // 출력 문자 색상 설정,BCD_NUM 값에 따라 출력 문자 색상 변경 가능 = 0;
      }
       move_motion++;
      if (move_motion == 3)
      {
        move_motion = 0;
        char_cnt++;
        if(char_cnt == 109) //109개 문자 선택을 위한 카운트 
        {
          char_cnt = 0;
        }
      }
    }
  }

  TCNT2 = 0xe7;
}

void setup()
{
  DDRB = 0xff;  // PORTB 출력 방향 설정
  DDRC = 0xff;  // PORTC 출력 방향 설정
  DDRD = 0xff;  // PORTD 출력 방향 설정
  TCCR2A = 0x00;
  TCCR2B = 0x04;  // 타이머 카운터2 노멀 모드, 64분주 
  TIMSK2 = 0x01;  // 타이머 카운터2 인터럽트 허용
  TCNT2 = 0xe7; // 타이머 카운터2 초기값: 231
  SREG = 0x80;  // 인터럽트 허용
}

void row_dynamic(unsigned char i)
{
  if(i<16)
  {
    switch (i)  // 행 이동
    {
      case 0:
        A_Low;B_Low;C_Low;D_Low;break;  // 1행 LED 
      case 1:
        A_High;B_Low;C_Low;D_Low;break;  // 2행 LED 
      case 2:
        A_Low;B_High;C_Low;D_Low;break;  // 3행 LED 
      case 3:
        A_High;B_High;C_Low;D_Low;break;  // 4행 LED 
      case 4:
        A_Low;B_Low;C_High;D_Low;break;  // 5행 LED 
      case 5:
        A_High;B_Low;C_High;D_Low;break;  // 6행 LED 
      case 6:
        A_Low;B_High;C_High;D_Low;break;  // 7행 LED 
      case 7:
        A_High;B_High;C_High;D_Low;break;  // 8행 LED
      case 8:
        A_Low;B_Low;C_Low;D_High;break;  // 9행 LED
      case 9:
        A_High;B_Low;C_Low;D_High;break;  // 10행 LED
      case 10:
        A_Low;B_High;C_Low;D_High;break;  // 11행 LED
      case 11:
        A_High;B_High;C_Low;D_High;break;  // 12행 LED
      case 12:
        A_Low;B_Low;C_High;D_High;break;  // 13행 LED
      case 13:
        A_High;B_Low;C_High;D_High;break;  // 14행 LED
      case 14:
        A_Low;B_High;C_High;D_High;
        break;  // 15행 LED
      case 15:
        A_High;B_High;C_High;D_High;break;
      default:
        A_Low;B_Low;C_Low;D_Low;break; 
    }
  }
  else   {
    switch (i-16)  // 행 이동
    {
      case 0:
        A_Low;B_Low;C_Low;D_Low;break;  // 1행 LED 
      case 1:
        A_High;B_Low;C_Low;D_Low;break;  // 2행 LED 
      case 2:
        A_Low;B_High;C_Low;D_Low;break;  // 3행 LED 
      case 3:
        A_High;B_High;C_Low;D_Low;break;  // 4행 LED 
      case 4:
        A_Low;B_Low;C_High;D_Low;break;  // 5행 LED 
      case 5:
        A_High;B_Low;C_High;D_Low;break;  // 6행 LED 
      case 6:
        A_Low;B_High;C_High;D_Low;break;  // 7행 LED 
      case 7:
        A_High;B_High;C_High;D_Low;break;  // 8행 LED
      case 8:
        A_Low;B_Low;C_Low;D_High;break;  // 9행 LED
      case 9:
        A_High;B_Low;C_Low;D_High;break;  // 10행 LED
      case 10:
        A_Low;B_High;C_Low;D_High;break;  // 11행 LED
      case 11:
        A_High;B_High;C_Low;D_High;break;  // 12행 LED
      case 12:
        A_Low;B_Low;C_High;D_High;break;  // 13행 LED
      case 13:
        A_High;B_Low;C_High;D_High;break;  // 14행 LED
      case 14:
        A_Low;B_High;C_High;D_High;
        break;  // 15행 LED
      case 15:
        A_High;B_High;C_High;D_High;break;
      default:
        A_Low;B_Low;C_Low;D_Low;break; 
    }
  }
}

void shift_Register2(unsigned char high, unsigned char low, unsigned char cnt_row)
{
  // 점등시키고자 하는 LED 16bit를 high(8bit), low(8bit)로 나누어
  // cnt_row 인자값에 따라 상위 8비트, 하위 8비트 출력
  static unsigned char clk = 0;
  static unsigned int buff = 0;
  buff = high << 8; // 상위 8bit 좌측으로 8번 시프트 
  buff |= low;  // 상위 8bit, 하위 8bit 결합
  for (clk = 0; clk < 16; clk++)
  {
    // 16비트 데이터를 1비트씩 시프트레지스터에 입력
    if (buff &(1 << clk))
    {
      switch (BCD_Num)
      {
        case 0:
          R1_OFF;
          G1_OFF;
          B1_OFF;
          R2_OFF;
          G2_OFF;
          B2_OFF;
          break;
        case 1: // Red  
          if (cnt_row < 16)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF 
            R1_ON;
            G1_OFF;
            B1_OFF;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_ON;
            G2_OFF;
            B2_OFF;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }

          break;
        case 2: // Green
          if (cnt_row <= 15)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF
            R1_OFF;
            G1_ON;
            B1_OFF;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_OFF;
            G2_ON;
            B2_OFF;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }

          break;
        case 3: // Blue
          if (cnt_row < 16)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF 
            R1_OFF;
            G1_OFF;
            B1_ON;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_OFF;
            G2_OFF;
            B2_ON;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }

          break;

        case 4: // Pink
          if (cnt_row < 16)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF 
            R1_ON;
            B1_ON;
            G1_OFF;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_ON;
            B2_ON;
            G2_OFF;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }

          break;

        case 5: // Yellow  
          if (cnt_row < 16)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF 
            R1_ON;
            G1_ON;
            B1_OFF;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_ON;
            G2_ON;
            B2_OFF;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }

          break;
        case 6: // Sky  
          if (cnt_row < 16)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF 
            R1_OFF;
            G1_ON;
            B1_ON;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_OFF;
            G2_ON;
            B2_ON;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }

          break;
        case 7: // White  
          if (cnt_row < 16)
          {
            // 상위 8비트 디스플레이 ON, 하위 8비트 디스플레이 OFF 
            R1_ON;
            G1_ON;
            B1_ON;
            R2_OFF;
            B2_OFF;
            G2_OFF;
          }
          else
          {
            // 하위 8비트 디스플레이 ON, 상위 8비트 디스플레이 OFF
            R2_ON;
            G2_ON;
            B2_ON;
            R1_OFF;
            B1_OFF;
            G1_OFF;
          }
          break;
        default:
          R1_OFF;
          G1_OFF;
          B1_OFF;
          // 상위 8비트 디스플레이 OFF, 하위 8비트 디스플레이 OFF 
          R2_OFF;
          G2_OFF;
          B2_OFF;
          break;
      }
    }
    else
    {
      R1_OFF;
      G1_OFF;
      B1_OFF;
      R2_OFF;
      G2_OFF;
      B2_OFF;
    }

    Clk_enable; // CLK 신호 활성화
    Clk_disable;
  }
}

void ActivePulse()  // 스트로브 신호
{
  LE_enable;
  LE_disable; // LE 신호 활성화   
  OE_enable;  // OE 신호 활성화
  delayMicroseconds(300); // 300uS 딜레이 
  OE_disable;
}
unsigned long sum_num_variable(unsigned int high, unsigned int low)
{
  unsigned long LongData = 0;
  LongData = high;
  LongData = LongData << 16 | low;
  return LongData;
}
void dot1_display() // 도트매트릭스 문자 출력 함수
{
  static unsigned int i_cnt = 0;
  unsigned int data_shift_high = { 0 }; 
  unsigned int data_shift_low = { 0 }; 
  unsigned long buff1[32] = { 0 };
  unsigned int high1 = 0; 
  unsigned int low1 = 0; 
  unsigned int high2 = 0; 
  unsigned int low2 = 0; 
  unsigned long temp, LongBuff = 0; 

  register unsigned int i = 0;
  

  for (i = 0; i < 32; i++)
  {    
    /*
     * sum_num_variable 2개의 16비트 메모리를 하나로 합치는 동작을 수행함.
     * 도트매트릭스 LED 모듈의 첫행의 각 열의 32비트 메모리값은 편집기에 의해서 2개로 생성됨 
     * 즉 위에서 선언된 String 변수에 0열 16비트 메모리값과 32열 16비트를 메모리값을 머지(Merge)시켜 32비트로 구성시키는 동작이 필요  
     */
    switch (move_motion) {
    case 0:
      LongBuff = sum_num_variable(pgm_read_word(&string[char_cnt][i + 32]), pgm_read_word(&string[char_cnt][i]));
      temp = (LongBuff<< Move_cnt);
      data_shift_high = temp>>16;
      high1 = (data_shift_high >> 8);  //  상위 8Bit 31~23  저장
      low1 = (data_shift_high &0xff);  //  하위 8Bit 22~16 저장
     
      data_shift_low = (LongBuff<< Move_cnt) & 0x0000ffff;
      high2 = (data_shift_low >> 8);  // 상위 8Bit 15~8 저장
      low2 = (data_shift_low &0xff);  // 하위 8Bit 7~0 저장
      shift_Register2(high2, low2, i);  // 하위 16bit LED 구동 클럭
      shift_Register2(high1, low1, i);  // 상위 16bit LED 구동 클럭
      break;
    case 1:
      LongBuff = sum_num_variable(pgm_read_word(&string[char_cnt][i + 32]), pgm_read_word(&string[char_cnt][i]));
      temp = LongBuff;
      data_shift_high = temp>>16;
      high1 = (data_shift_high >> 8);  //  상위 8Bit 31~23  저장
      low1 = (data_shift_high &0xff);  //  하위 8Bit 22~16 저장
      data_shift_low = LongBuff & 0x0000ffff;
      high2 = (data_shift_low >> 8);  // 상위 8Bit 15~8 저장
      low2 = (data_shift_low &0xff);  // 하위 8Bit 7~0 저장
      shift_Register2(high2, low2, i);  // 하위 16bit LED 구동 클럭
      shift_Register2(high1, low1, i);  // 상위 16bit LED 구동 클럭
      break;
    case 2:
      LongBuff = sum_num_variable(pgm_read_word(&string[char_cnt][i + 32]), pgm_read_word(&string[char_cnt][i]));
      temp = (LongBuff >> Move_cnt2);
      data_shift_high = temp>>16;
      high1 = (data_shift_high >> 8);  //  상위 8Bit 31~23  저장
      low1 = (data_shift_high &0xff);  //  하위 8Bit 22~16 저장
      
      data_shift_low = (LongBuff >> Move_cnt2) & 0x0000ffff;
      high2 = (data_shift_low >> 8);  // 상위 8Bit 15~8 저장
      low2 = (data_shift_low &0xff);  // 하위 8Bit 7~0 저장
      shift_Register2(high2, low2, i);  // 하위 16bit LED 구동 클럭
      shift_Register2(high1, low1, i);  // 상위 16bit LED 구동 클럭
      break;
     }
      row_dynamic(i); // 0~32행 접근
      ActivePulse();  // 스트로브 신호
  }
}

void loop()
{
  dot1_display();
}
